/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.layouts;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;

public class BorderLayout
extends Layout {
    private Component north;
    private Component south;
    private Component center;
    private Component west;
    private Component east;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String CENTER = "Center";
    public static final String WEST = "West";
    public static final String EAST = "East";

    public void addLayoutComponent(Object name, Component comp, Container c) {
        Component previous = null;
        if (CENTER.equals(name)) {
            previous = this.center;
            this.center = comp;
        } else if (NORTH.equals(name)) {
            previous = this.north;
            this.north = comp;
        } else if (SOUTH.equals(name)) {
            previous = this.south;
            this.south = comp;
        } else if (EAST.equals(name)) {
            previous = this.east;
            this.east = comp;
        } else if (WEST.equals(name)) {
            previous = this.west;
            this.west = comp;
        } else {
            throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + name);
        }
        if (previous != null && previous != comp) {
            c.removeComponent(previous);
        }
    }

    public void removeLayoutComponent(Component comp) {
        if (comp == this.center) {
            this.center = null;
        } else if (comp == this.north) {
            this.north = null;
        } else if (comp == this.south) {
            this.south = null;
        } else if (comp == this.east) {
            this.east = null;
        } else if (comp == this.west) {
            this.west = null;
        }
    }

    public Object getComponentConstraint(Component comp) {
        if (comp == this.center) {
            return CENTER;
        }
        if (comp == this.north) {
            return NORTH;
        }
        if (comp == this.south) {
            return SOUTH;
        }
        if (comp == this.east) {
            return EAST;
        }
        return WEST;
    }

    public void layoutContainer(Container target) {
        Component c;
        int top = target.getStyle().getPadding(0);
        int bottom = target.getLayoutHeight() - target.getBottomGap() - target.getStyle().getPadding(2);
        int left = target.getStyle().getPadding(1);
        int right = target.getLayoutWidth() - target.getSideGap() - target.getStyle().getPadding(3);
        int targetWidth = target.getWidth();
        int targetHeight = target.getHeight();
        if (this.north != null) {
            c = this.north;
            this.positionTopBottom(c, right, left, targetHeight);
            c.setY(top + c.getStyle().getMargin(0));
            top += c.getHeight() + c.getStyle().getMargin(0) + c.getStyle().getMargin(2);
        }
        if (this.south != null) {
            c = this.south;
            this.positionTopBottom(c, right, left, targetHeight);
            c.setY(bottom - c.getHeight() - c.getStyle().getMargin(0));
            bottom -= c.getHeight() + c.getStyle().getMargin(0) + c.getStyle().getMargin(2);
        }
        if (this.east != null) {
            c = this.east;
            this.positionLeftRight(this.east, targetWidth, bottom, top);
            c.setX(right - c.getWidth() - c.getStyle().getMargin(1));
            right -= c.getWidth() + c.getStyle().getMargin(1) + c.getStyle().getMargin(3);
        }
        if (this.west != null) {
            c = this.west;
            this.positionLeftRight(this.west, targetWidth, bottom, top);
            c.setX(left + c.getStyle().getMargin(1));
            left += c.getWidth() + c.getStyle().getMargin(1) + c.getStyle().getMargin(3);
        }
        if (this.center != null) {
            c = this.center;
            c.setWidth(right - left - c.getStyle().getMargin(1) - c.getStyle().getMargin(3));
            c.setHeight(bottom - top - c.getStyle().getMargin(0) - c.getStyle().getMargin(2));
            c.setX(left + c.getStyle().getMargin(1));
            c.setY(top + c.getStyle().getMargin(0));
        }
    }

    private void positionLeftRight(Component c, int targetWidth, int bottom, int top) {
        c.setWidth(Math.min(targetWidth, c.getPreferredW()));
        c.setHeight(bottom - top - c.getStyle().getMargin(0) - c.getStyle().getMargin(2));
        c.setY(top + c.getStyle().getMargin(0));
    }

    private void positionTopBottom(Component c, int right, int left, int targetHeight) {
        c.setWidth(right - left - c.getStyle().getMargin(1) - c.getStyle().getMargin(3));
        c.setHeight(Math.min(targetHeight, c.getPreferredH()));
        c.setX(left + c.getStyle().getMargin(1));
    }

    public Dimension getPreferredSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        if (this.east != null) {
            dim.setWidth(this.east.getPreferredW() + this.east.getStyle().getMargin(1) + this.east.getStyle().getMargin(3));
            dim.setHeight(Math.max(this.east.getPreferredH() + this.east.getStyle().getMargin(0) + this.east.getStyle().getMargin(2), dim.getHeight()));
        }
        if (this.west != null) {
            dim.setWidth(dim.getWidth() + this.west.getPreferredW() + this.west.getStyle().getMargin(1) + this.west.getStyle().getMargin(3));
            dim.setHeight(Math.max(this.west.getPreferredH() + this.west.getStyle().getMargin(0) + this.west.getStyle().getMargin(2), dim.getHeight()));
        }
        if (this.center != null) {
            dim.setWidth(dim.getWidth() + this.center.getPreferredW() + this.center.getStyle().getMargin(1) + this.center.getStyle().getMargin(3));
            dim.setHeight(Math.max(this.center.getPreferredH() + this.center.getStyle().getMargin(0) + this.center.getStyle().getMargin(2), dim.getHeight()));
        }
        if (this.north != null) {
            dim.setWidth(Math.max(this.north.getPreferredW() + this.north.getStyle().getMargin(1) + this.north.getStyle().getMargin(3), dim.getWidth()));
            dim.setHeight(dim.getHeight() + this.north.getPreferredH() + this.north.getStyle().getMargin(0) + this.north.getStyle().getMargin(2));
        }
        if (this.south != null) {
            dim.setWidth(Math.max(this.south.getPreferredW() + this.south.getStyle().getMargin(1) + this.south.getStyle().getMargin(3), dim.getWidth()));
            dim.setHeight(dim.getHeight() + this.south.getPreferredH() + this.south.getStyle().getMargin(0) + this.south.getStyle().getMargin(2));
        }
        dim.setWidth(dim.getWidth() + parent.getStyle().getPadding(1) + parent.getStyle().getPadding(3));
        dim.setHeight(dim.getHeight() + parent.getStyle().getPadding(0) + parent.getStyle().getPadding(2));
        return dim;
    }

    protected Component getSouth() {
        return this.south;
    }

    protected Component getCenter() {
        return this.center;
    }

    protected Component getNorth() {
        return this.north;
    }

    protected Component getEast() {
        return this.east;
    }

    protected Component getWest() {
        return this.west;
    }
}

